/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.admin.property.uddi.VWConfigUDDIInfoPanel;
import filenet.vw.toolkit.admin.property.wsrr.VWConfigWSRRInfoPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class VWConfigWebServicesPanel
extends JPanel {
    private Frame m_parentFrame = null;
    private VWAttributeInfo m_vwAttributeInfo = null;
    private VWSession m_vwSession = null;
    private VWSessionInfo m_sessionInfo = null;
    private String m_key = "F_AllowUserEnterWSDL";
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    protected VWConfigUDDIInfoPanel m_uddiInfoPanel = null;
    protected VWConfigWSRRInfoPanel m_WSRRInfoPanel = null;
    private JCheckBox m_allowUserEnterWSDLCheckBox = null;
    private boolean m_bAllowUserEnterWSDL = false;
    private boolean m_bModified = false;

    public VWConfigWebServicesPanel(Frame parentFrame, VWSessionInfo sessionInfo, VWAttributeInfo vwAttributeInfo) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_sessionInfo = sessionInfo;
            this.m_vwSession = sessionInfo.getSession();
            this.m_vwAttributeInfo = vwAttributeInfo;
            this.m_bAllowUserEnterWSDL = VWConfigWebServicesPanel.retrieveWSDLEnabled(this.m_vwSession, this.m_vwAttributeInfo);
            this.createControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        if (this.m_allowUserEnterWSDLCheckBox.isSelected() != this.m_bAllowUserEnterWSDL) {
            this.m_bModified = true;
            try {
                String sValue = "0";
                if (this.m_allowUserEnterWSDLCheckBox.isSelected()) {
                    sValue = "1";
                }
                this.m_vwAttributeInfo.setFieldValue(this.m_key, sValue);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        if (this.m_uddiInfoPanel.hasChanged()) {
            this.m_bModified = true;
        }
        if (this.m_WSRRInfoPanel.hasChanged()) {
            this.m_bModified = true;
        }
        return this.m_bModified;
    }

    public boolean update() {
        if (!this.m_uddiInfoPanel.update()) {
            return false;
        }
        return this.m_WSRRInfoPanel.update();
    }

    public void createControls() {
        try {
            Font aFont = this.getFont();
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.m_tabbedPanel.setFont(new Font(aFont.getName(), 1, aFont.getSize()));
            VWAccessibilityHelper.setAccessibility(this.m_tabbedPanel, this, VWResource.WebServicesTabbedPane, VWResource.WebServicesTabbedPane);
            this.m_tabbedPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_WSRRInfoPanel = new VWConfigWSRRInfoPanel(this.m_parentFrame, this.m_sessionInfo, this.m_vwAttributeInfo);
            this.m_tabbedPanel.add("WSRR", this.m_WSRRInfoPanel);
            this.m_uddiInfoPanel = new VWConfigUDDIInfoPanel(this.m_parentFrame, this.m_sessionInfo, this.m_vwAttributeInfo);
            this.m_tabbedPanel.add(VWResource.UDDI, this.m_uddiInfoPanel);
            this.add(this.m_tabbedPanel);
            this.m_allowUserEnterWSDLCheckBox = new JCheckBox(VWResource.EnableEnteringWSDL);
            this.m_allowUserEnterWSDLCheckBox.setSelected(this.m_bAllowUserEnterWSDL);
            VWAccessibilityHelper.setAccessibility(this.m_allowUserEnterWSDLCheckBox, this, VWResource.EnableEnteringWSDL, VWResource.EnableEnteringWSDL);
            this.m_allowUserEnterWSDLCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.add((Component)this.m_tabbedPanel, "Center");
            this.add((Component)this.m_allowUserEnterWSDLCheckBox, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_vwAttributeInfo = null;
        if (this.m_allowUserEnterWSDLCheckBox != null) {
            this.m_allowUserEnterWSDLCheckBox.removeAll();
            this.m_allowUserEnterWSDLCheckBox = null;
        }
        this.removeAll();
    }

    public static boolean retrieveWSDLEnabled(VWSession session, VWAttributeInfo vwAttributeInfo) {
        VWSession vwSession = session;
        VWUDDIRegistryList uddiRegistryList = null;
        String key = "F_AllowUserEnterWSDL";
        boolean bEnabled = false;
        try {
            if (vwSession == null) {
                return false;
            }
            if (vwAttributeInfo != null) {
                String sAllow = (String)vwAttributeInfo.getFieldValue(key);
                bEnabled = sAllow != null ? sAllow.compareTo("1") == 0 : ((uddiRegistryList = new VWUDDIRegistryList(vwAttributeInfo, vwSession)) != null ? uddiRegistryList.getAllowUserEnterWSDL() : false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            bEnabled = false;
        }
        return bEnabled;
    }
}

